<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>سند صرف من الحساب</title>
    <style>
        .invoice-box {
            max-width: 800px;
            margin: auto;
            padding: 30px;
            border: 1px solid #eee;
            box-shadow: 0 0 10px rgb(0 0 0 / 15%);
            font-size: 16px;
            line-height: 24px;
            font-family: 'Cairo', sans-serif;
            color: #555;
            text-align: right;
        }

        .top {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            font-size: 20px;
            font-weight: bold;
            padding-bottom: 20px;
            border-bottom: 4px solid #193B62;
        }

        .top span:nth-child(1) {
            display: block;
        }

        .top .right {
            display: flex;
            align-items: center;
            flex-direction: column;
            align-content: center;
        }

        .top .center {
            display: flex;
            align-items: center;

        }

        .information {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: center;
            margin-top: 20px;
            padding-left: 50px;
            padding-right: 50px;
        }



        .information .right {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;
        }

        .information .center {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .information .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .information-main {

            margin-top: 30px;
            padding-left: 90px;
            padding-right: 90px;
        }



        .information-main .right {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;
        }

        .information-main .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .left span:nth-child(1) {
            display: block;
        }

        .left span:nth-child(2) {
            display: block;
        }

        span {
            margin-right: 8px;
            font-weight: 500;
        }

        .bold {
            font-weight: bold;
        }

        .botom {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            margin-top: 40px;
            padding-left: 50px;
            padding-right: 50px;

        }


        .seg2 {
            display: flex;
            flex-direction: row-reverse;
            justify-content: space-between;
        }

        .botom .seg {
            display: flex;
            flex-direction: column;
            align-content: center;

        }

        .botom .center {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .botom .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .botom-seg {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            margin-top: 10px;
            padding-left: 50px;
            padding-right: 50px;
            margin-bottom: 40px;
        }



        .botom-seg .right {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;
        }

        .botom-seg .center {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .botom-seg .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .top-text {
            display: flex;
            margin-bottom: 20px;
            flex-direction: row-reverse;
        }

        .botom-text {
            display: flex;

            flex-direction: row-reverse;
        }

        @media print {
            .invoice-box {
                max-width: unset;
                box-shadow: none;
                border: 0px;
            }
        }

        @page {
            size: A4 landscape
        }
    </style>
</head>

<body>
    <div class="invoice-box">
        <div class="top">
            <div class="right">
                <span>الجمهورية اليمنية</span>
                <span>صنعاء شارع الستين</span>
                <span>+967 773344551</span>
            </div>
            <div class="center">
                <img width="200" src="<?php echo e(asset('/images/logo-full.png')); ?>" alt="">

            </div>
            <div class="left">
                <span class="">رقم السند :
                    <?php if(isset($receptId)): ?>
                        <?php echo e($receptId); ?>

                    <?php endif; ?>
                </span>
                <span class="" id="hijri">

                </span>
                <span class="" id="milady">
                </span>
            </div>
        </div>

        <div class="information">

            <div class="center">
                <span class="bold">سند استلام</span>
            </div>

        </div>



        <div class="botom">
            <div class="seg">
                <div class="top-text">
                    <span class="bold">: استلمت من الأخوة</span>
                    <span>محطة حنيش </span>
                </div>
                <div class="botom-text">
                    <span class="bold">: الكمية</span>
                    <span>
                        <?php if(isset($quantity)): ?>
                            <?php echo e($quantity); ?>

                        <?php endif; ?>
                    </span>
                </div>
               
            </div>
            <div class="seg">
                <div class="top-text">
                    <span class="bold">: ملاحظة</span>
                    <span>
                        <?php if(isset($notice)): ?>
                            <?php echo e($notice); ?>

                        <?php endif; ?>
                    </span>
                </div>
                <div class="botom-text">
                    <span class="bold">: النوع</span>
                    <span>
                        <?php if(isset($type)): ?>
                            <?php if($type == 0): ?>
                                بترول
                            <?php else: ?>
                                ديزل
                            <?php endif; ?>
                        <?php endif; ?>
                    </span>
                </div>
            </div>

        </div>
        <div class="botom">
            <div class="seg">
                <div class="top-text">
                    <span class="bold">: المستلم</span>
                    <span>
                        <?php if(isset($clintName)): ?>
                            <?php echo e($clintName); ?>

                        <?php endif; ?>
                    </span>
                </div>
                <div class="botom-text">
                    <span class="bold">: التوقيع</span>
                    <span>........................</span>
                </div>
            </div>
            <div class="seg">
                <div class="top-text">
                    <span class="bold">: المحاسب</span>
                    <span>
                        <?php if(isset($accounterName)): ?>
                            <?php echo e($accounterName); ?>

                        </span>
                    <?php endif; ?>
                </div>

                <div class="botom-text">
                    <span class="bold">: التوقيع</span>
                    <span>........................</span>
                </div>
            </div>
            <div class="seg">
                <div class="top-text">
                    <span class="bold">: المدير</span>
                    <span>محمد عزيز شحرة</span>
                </div>

                <div class="botom-text">
                    <span class="bold">: التوقيع</span>
                    <span>........................</span>
                </div>
            </div>
        </div>

        <div class="botom"
            style="
        margin-top: 80px;
        border-top: 2px dotted #193B62;
        padding-top: 30px;
    ">

            <div class="seg">
                <div class="top-text">
                    <span class="bold">: يصرف للأخ</span>
                    <span>
                        <?php if(isset($clintName)): ?>
                            <?php echo e($clintName); ?>

                        <?php endif; ?>
                    </span>
                </div>
                <div class="botom-text">
                    <span class="bold">: اسم العامل</span>
                    <span>
                        <?php if(isset($employeeName)): ?>
                            <?php echo e($employeeName); ?>

                        <?php endif; ?>
                    </span>
                </div>


            </div>
            <div class="seg">
                <div class="top-text">
                    <span class="bold">: كمية</span>
                    <span>
                        <?php if(isset($quantity)): ?>
                            <?php echo e($quantity); ?>

                        <?php endif; ?>
                    </span>
                    <span class="bold">لتر</span>
                </div>

                <div class="botom-text">
                    <span class="bold">: رقم الطرمبة</span>
                    <span>
                        <?php if(isset($pumpId)): ?>
                            <?php echo e($pumpId); ?>

                        <?php endif; ?>
                    </span>
                </div>
            </div>
            <div class="seg">
                <div class="top-text">

                    <span class="bold">: نوع</span>
                    <span>
                        <?php if(isset($type)): ?>
                            <?php if($type == 0): ?>
                                بترول
                            <?php else: ?>
                                ديزل
                            <?php endif; ?>
                        <?php endif; ?>
                    </span>
                </div>

                <div class="botom-text">
                    <span class="bold">: التاريخ</span>
                    <span> <?php if(isset($dateTime)): ?>
                            <?php echo e($dateTime); ?>

                        <?php endif; ?>
                    </span>
                </div>
            </div>
        </div>


    </div>

</body>
<script src="<?php echo e(asset('/js/date/hijri.js')); ?>"></script>

</html>
<?php /**PATH C:\Users\Nasser\Desktop\petrol_store\resources\views/receiptFromAcount.blade.php ENDPATH**/ ?>